/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.DecimalRepBuf;
import cc.tweaked.cobalt.internal.doubles.Doubles;
import cc.tweaked.cobalt.internal.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.SignedPositive;
import org.checkerframework.checker.signedness.qual.Unsigned;

final class FixedDtoa {
    private static final int DOUBLE_SIGNIFICAND_SIZE = 53;
    private static final @Unsigned long TEN_POW_OF_7 = 10000000L;

    FixedDtoa() {
    }

    private static void fillDigits32FixedLength(@Unsigned int number, int requestedLength, DecimalRepBuf buf) {
        int start = buf.length();
        buf.addLength(requestedLength);
        for (int i = buf.length() - 1; i >= start; --i) {
            buf.setCharAt(i, UnsignedValues.uRemainder(number, 10));
            number = UnsignedValues.uDivide(number, 10);
        }
    }

    private static void fillDigits32(@Unsigned int number, DecimalRepBuf buf) {
        int start = buf.length();
        while (number != 0) {
            @Unsigned int digit = UnsignedValues.uRemainder(number, 10);
            number = UnsignedValues.uDivide(number, 10);
            buf.append(digit);
        }
        buf.reverseLast(start);
    }

    private static void fillDigits64FixedLength(@Unsigned long number, DecimalRepBuf buf) {
        @Unsigned int part2 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        number = UnsignedValues.uDivide(number, 10000000L);
        @Unsigned int part1 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        @Unsigned int part0 = UnsignedValues.toUint(UnsignedValues.uDivide(number, 10000000L));
        FixedDtoa.fillDigits32FixedLength(part0, 3, buf);
        FixedDtoa.fillDigits32FixedLength(part1, 7, buf);
        FixedDtoa.fillDigits32FixedLength(part2, 7, buf);
    }

    private static void fillDigits64(@Unsigned long number, DecimalRepBuf buf) {
        @Unsigned int part2 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        number = UnsignedValues.uDivide(number, 10000000L);
        @Unsigned int part1 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        @Unsigned int part0 = UnsignedValues.toUint(UnsignedValues.uDivide(number, 10000000L));
        if (part0 != 0) {
            FixedDtoa.fillDigits32(part0, buf);
            FixedDtoa.fillDigits32FixedLength(part1, 7, buf);
            FixedDtoa.fillDigits32FixedLength(part2, 7, buf);
        } else if (part1 != 0) {
            FixedDtoa.fillDigits32(part1, buf);
            FixedDtoa.fillDigits32FixedLength(part2, 7, buf);
        } else {
            FixedDtoa.fillDigits32(part2, buf);
        }
    }

    private static void fillFractionals(@Unsigned long fractionals, int exponent, int fractionalCount, DecimalRepBuf buf) {
        assert (-128 <= exponent && exponent <= 0);
        if (-exponent <= 64) {
            int digit;
            assert (fractionals >>> 56 == 0L);
            int point = -exponent;
            for (int i = 0; i < fractionalCount && fractionals != 0L; fractionals -= UnsignedValues.toUlong(digit) << point, ++i) {
                digit = UnsignedValues.toUint((fractionals *= 5L) >>> --point);
                buf.append(digit);
            }
            assert (fractionals == 0L || point - 1 >= 0);
            if (fractionals != 0L && (fractionals >>> point - 1 & 1L) == 1L) {
                buf.roundUp();
            }
        } else {
            assert (64 < -exponent && -exponent <= 128);
            UInt128 fractionals128 = new UInt128(fractionals, 0L);
            fractionals128 = fractionals128.shift(-exponent - 64);
            int point = 128;
            for (int i = 0; i < fractionalCount && !fractionals128.isZero(); ++i) {
                fractionals128 = fractionals128.times(5L);
                UInt128.QuotientRemainder qr = fractionals128.divModPowerOf2(--point);
                @Unsigned int digit = qr.quotient;
                fractionals128 = qr.remainder;
                buf.append(digit);
            }
            if (fractionals128.bitAt(point - 1) == 1) {
                buf.roundUp();
            }
        }
    }

    public static boolean fastFixedDtoa(double v, int fractionalCount, DecimalRepBuf buf) {
        @Unsigned long kMaxUInt32 = 0xFFFFFFFFL;
        @Unsigned long significand = Doubles.significand(v);
        int exponent = Doubles.exponent(v);
        if (exponent > 20) {
            return false;
        }
        if (fractionalCount > 20) {
            return false;
        }
        buf.clearBuf();
        if (exponent + 53 > 64) {
            long remainder;
            int quotient;
            @SignedPositive int positiveExponent = exponent;
            @Unsigned long kFive17 = 762939453125L;
            @Unsigned long divisor = 762939453125L;
            @SignedPositive int divisorPower = 17;
            @Unsigned long dividend = significand;
            if (exponent > divisorPower) {
                quotient = UnsignedValues.toUint(UnsignedValues.uDivide(dividend <<= (int)UnsignedValues.toUlongFromSigned(positiveExponent - divisorPower), divisor));
                remainder = UnsignedValues.uRemainder(dividend, divisor) << divisorPower;
            } else {
                quotient = UnsignedValues.toUint(UnsignedValues.uDivide(dividend, divisor <<= (int)UnsignedValues.toUlongFromSigned(divisorPower - positiveExponent)));
                remainder = UnsignedValues.uRemainder(dividend, divisor) << exponent;
            }
            FixedDtoa.fillDigits32(quotient, buf);
            FixedDtoa.fillDigits64FixedLength(remainder, buf);
            buf.setPointPosition(buf.length());
        } else if (exponent >= 0) {
            FixedDtoa.fillDigits64(significand <<= exponent, buf);
            buf.setPointPosition(buf.length());
        } else if (exponent > -53) {
            long integrals = significand >>> -exponent;
            long fractionals = significand - (integrals << -exponent);
            if (!UnsignedValues.isAssignableToUint(integrals)) {
                FixedDtoa.fillDigits64(integrals, buf);
            } else {
                FixedDtoa.fillDigits32(UnsignedValues.toUint(integrals), buf);
            }
            buf.setPointPosition(buf.length());
            FixedDtoa.fillFractionals(fractionals, exponent, fractionalCount, buf);
        } else if (exponent < -128) {
            assert (fractionalCount <= 20);
            buf.clearBuf();
            buf.setPointPosition(-fractionalCount);
        } else {
            buf.setPointPosition(0);
            FixedDtoa.fillFractionals(significand, exponent, fractionalCount, buf);
        }
        buf.trimZeros();
        if (buf.length() == 0) {
            buf.setPointPosition(-fractionalCount);
        }
        return true;
    }

    static class UInt128 {
        private static final @Unsigned long MASK_32 = 0xFFFFFFFFL;
        private final @Unsigned long high;
        private final @Unsigned long low;

        public UInt128() {
            this.high = 0L;
            this.low = 0L;
        }

        public UInt128(@Unsigned long high, @Unsigned long low) {
            this.high = high;
            this.low = low;
        }

        @Unsigned long rawHigh() {
            return this.high;
        }

        @Unsigned long rawLow() {
            return this.low;
        }

        public UInt128 times(@Unsigned long multiplicand) {
            long accumulator = (this.low & 0xFFFFFFFFL) * multiplicand;
            long part = accumulator & 0xFFFFFFFFL;
            accumulator >>>= 32;
            long newLowBits = ((accumulator += (this.low >>> 32) * multiplicand) << 32) + part;
            accumulator >>>= 32;
            part = (accumulator += (this.high & 0xFFFFFFFFL) * multiplicand) & 0xFFFFFFFFL;
            accumulator >>>= 32;
            long newHighBits = ((accumulator += (this.high >>> 32) * multiplicand) << 32) + part;
            assert (accumulator >>> 32 == 0L);
            return new UInt128(newHighBits, newLowBits);
        }

        public UInt128 shift(int shift_amount) {
            long nLow;
            long nHigh;
            assert (-64 <= shift_amount && shift_amount <= 64);
            if (shift_amount == 0) {
                return this;
            }
            if (shift_amount == -64) {
                nHigh = this.low;
                nLow = 0L;
            } else if (shift_amount == 64) {
                nHigh = 0L;
                nLow = this.high;
            } else if (shift_amount <= 0) {
                nHigh = this.high << -shift_amount;
                nHigh += this.low >>> 64 + shift_amount;
                nLow = this.low << -shift_amount;
            } else {
                nLow = this.low >>> shift_amount;
                nLow += this.high << 64 - shift_amount;
                nHigh = this.high >>> shift_amount;
            }
            return new UInt128(nHigh, nLow);
        }

        public QuotientRemainder divModPowerOf2(int power) {
            long remLow;
            long remHigh;
            int quotient;
            if (power >= 64) {
                quotient = UnsignedValues.toUint(this.high >>> power - 64);
                remHigh = this.high - ((long)quotient << power - 64);
                remLow = this.low;
            } else {
                long partLow = this.low >>> power;
                long partHigh = this.high << 64 - power;
                quotient = (int)(partLow + partHigh);
                remHigh = 0L;
                remLow = this.low - (partLow << power);
            }
            return new QuotientRemainder(quotient, new UInt128(remHigh, remLow));
        }

        public boolean isZero() {
            return this.high == 0L && this.low == 0L;
        }

        public int bitAt(int position) {
            if (position >= 64) {
                return (int)(this.high >>> position - 64) & 1;
            }
            return (int)(this.low >>> position) & 1;
        }

        public static class QuotientRemainder {
            public final @Unsigned int quotient;
            public final UInt128 remainder;

            public QuotientRemainder(@Unsigned int quotient, UInt128 remainder) {
                this.quotient = quotient;
                this.remainder = remainder;
            }
        }
    }
}

